/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: PilotMain.c
 *
 * Description:
 *	  This is the main source module for a Palm OS application.
 *
 *****************************************************************************/

#include <PalmOS.h>


/***********************************************************************
 *
 * FUNCTION:    PilotMain
 *
 * DESCRIPTION: The entry point for all Palm OS applications, this 
 *				function's sole purpose is to receive and respond to 
 *				launch codes. 
 *
 * PARAMETERS:  -> cmd	The launch code to which your application is to 
 *					respond. See Palm OS Programmer's API Reference 
 *					Chapter 1, "Application Launch Codes," 
 *					for a list of predefined launch codes. You may create 
 *					additional launch codes; see "Creating Your Own Launch 
 *					Codes" of the Palm OS Programmer's Companion, vol. I. 
 *
 *				-> cmdPBP A pointer to a structure containing any 
 *					launch-command-specific parameters, or NULL if the
 *					launch code has none. See the description of each launch 
 *					code for a description of the parameter structure that 
 *					accompanies it, if any. 
 *
 *				-> launchFlags Flags that indicate whether your application's 
 *					global variables are available, whether your application 
 *					is now the active application, whether it already was the 
 *					active application, and so on. See "Launch Flags" for a 
 *					list of launch flags. 

 *
 * RETURNED:    Return errNone if your application processed the launch 
 *				code successfully, or an appropriate error code if there 
 *				was a problem. When another application invokes your 
 *				application using SysAppLaunch, this value is returned to
 *				the caller. 
 *
 ***********************************************************************/

UInt32 PilotMain (UInt16 cmd, void *cmdPBP, UInt16 launchFlags) 
{ 
   return errNone; 
} 
